# Ninja Forms - ConvertKit

Create custom email capture forms for ConvertKit using the Ninja Forms drag-and-drop form builder.

## Subscribe Action

Adds a form action for adding a subscriber to ConvertKit.

- Add subscriber to a form.
- Add subscriber to a sequence/course.
- Tag a subscriber.

Also supports updating a subscriber's custom fields, when subscribing to a form/sequence/tag.

## Class NF_ConvertKit_API

The API method returns an instance of the API Class.
Each instance is stored in memory by a reference to the passed API Key.
Multiple instances can be instantiated by passing different API Keys.

```php
$api_key = '1234567890abcd';
$api = NF_ConvertKit()->api( $api_key );
```

### List sequences
```php
// GET /v3/courses
$sequences = $api->get( 'courses' );
```

### Add subscriber to a sequence
```php
// POST /v3/courses/<course_id>/subscribe
$subscribe = $api->post( 'courses/1234/subscribe', array( 'email' => 'kyle@wpninjas.com' ) );
```