<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_ConvertKit_API
 */
final class NF_ConvertKit_API
{
    const URL = 'https://api.convertkit.com';
    const VERSION = 'v3';

    private $api_key;
    private $response;
    private $debug = false;

    public function __construct( $api_key = '' )
    {
        $this->api_key = $api_key;
    }

    public function get( $endpoint )
    {
        $response = get_transient( "nf_convertkit_get_$endpoint" );
        if( ! $response ) {
            // Format the request URL and append the API Key as a querystring.
            $url = add_query_arg( 'api_key', $this->api_key,
                $this->request_url( $endpoint )
            );

            $args[ 'blocking' ] = $this->debug;

            try {
                $this->response = wp_remote_get( $url );
            } catch ( Exception $e ) {
                // TODO: Handle API response Exception.
            }

            $response = json_decode( wp_remote_retrieve_body( $this->response ), true );
            set_transient( "nf_convertkit_get_$endpoint", $response, DAY_IN_SECONDS );
        }
        return $response;
    }

    public function post( $endpoint, $data = array() )
    {
        // Format the request URL.
        $url = $this->request_url( $endpoint );

        // Convert tags to a comma-separated list of tag ids.
        if( isset( $data[ 'tags' ] ) ) {
            if( ! is_array( $data[ 'tags' ] ) ) $data[ 'tags' ] = array( $data[ 'tags' ] );
            $data[ 'tags' ] = implode( ',', $data[ 'tags' ] );
        }

        // Add the API Key to the request arguments.
        $args[ 'body' ] = array_merge( $data, array( 'api_key' => $this->api_key ) );

        $args[ 'blocking' ] = $this->debug;

        try {
            $this->response = wp_remote_post( $url, $args );
        } catch( Exception $e ) {
            // TODO: Handle API response Exception.
        }
        return json_decode( wp_remote_retrieve_body( $this->response ), true );
    }

    public function set_debugging( $debug )
    {
        $this->debug = $debug;
    }

    private function request_url( $endpoint )
    {
        // Build the API URL using the base url, version, and endpoint.
        return trailingslashit( self::URL ) . trailingslashit( self::VERSION ) . $endpoint;
    }
}
