<?php

namespace YOOtheme\Builder\Wordpress\Toolset;

use YOOtheme\Builder\Source;
use YOOtheme\Str;

class SourceListener
{
    public static function initSource(Source $source)
    {
        // is toolset installed?
        if (!class_exists('\Toolset_Field_Group_Post_Factory')) {
            return;
        }

        $source->addType('User', Type\ToolsetType::class, 'user');
        $source->addType('UserToolsetFields', Type\FieldsType::class, 'user');
        $source->addType('ToolsetDateField', Type\DateFieldType::class);

        $arguments = [
            'public' => true,
            'show_ui' => true,
            'show_in_nav_menus' => true,
        ];

        foreach (get_post_types($arguments, 'objects') as $name => $type) {

            if (!$type->rest_base || $name === $type->rest_base) {
                continue;
            }

            $source->addType(Str::camelCase($name, true), Type\ToolsetType::class, $name);
            $source->addType(Str::camelCase([$name, 'toolset', 'fields'], true), Type\FieldsType::class, 'post', $name);
        }

        foreach (get_taxonomies($arguments, 'objects') as $name => $taxonomy) {

            if (!$taxonomy->rest_base) {
                continue;
            }

            $source->addType(Str::camelCase($name, true), Type\ToolsetType::class, $name);
            $source->addType(Str::camelCase([$name, 'toolset', 'fields'], true), Type\FieldsType::class, 'term', $name);
        }
    }
}
