<?php

namespace YOOtheme\Builder\Wordpress\Toolset\Type;

use YOOtheme\Builder\Source;
use YOOtheme\Builder\Wordpress\Toolset\Helper;

class GroupType
{
    /**
     * @var string
     */
    protected $fieldGroup;

    /**
     * Constructor.
     *
     * @param string $fieldGroup
     */
    public function __construct($fieldGroup)
    {
        $this->fieldGroup = $fieldGroup;
    }

    public function __invoke(Source $source)
    {
        $fields = [];
        $resolvers = [];
        foreach (Helper::fields('post', $this->fieldGroup['fieldSlugs'], $source) as $field) {
            $config = [
                'type' => 'String',
                'metadata' => [
                    'label' => $field['name'],
                    'group' => $this->fieldGroup['name'],
                ],
            ];

            $fieldConfig = Helper::loadField($field, $config);
            if (!$fieldConfig) {
                continue;
            }

            $fields[$field['slug']] = $fieldConfig;
            $resolvers[$field['slug']] = function ($item) use ($field) {
                return $this->resolveField($field, $item);
            };
        }

        return compact('fields', 'resolvers');
    }

    protected function resolveField($field, $item)
    {
        foreach ($item->get_fields() as $fieldInstance) {
            if ($fieldInstance->get_slug() === $field['slug']) {
                return Helper::getFieldValue($fieldInstance, $fieldInstance->to_array());
            }
        }
    }
}
