<?php

namespace YOOtheme\Builder\Wordpress\Toolset\Type;

use YOOtheme\Str;

class ToolsetType
{
    /**
     * @var string
     */
    protected $name;

    public function __construct($name)
    {
        $this->name = $name;
    }

    public function __invoke()
    {
        $fields = [

            'toolset' => [
                'type' => Str::camelCase([$this->name, 'toolset', 'fields'], true),
                'metadata' => [
                    'label' => 'Fields',
                ],
            ],

        ];

        $resolvers = [

            'toolset' => function ($item) {
                return $item;
            },

        ];

        return compact('fields', 'resolvers');
    }
}
