<?php

namespace YOOtheme\Builder\Wordpress\PopularPosts;

use YOOtheme\Builder\Source;
use YOOtheme\Str;

class SourceListener
{
    public static function initSource(Source $source)
    {
        if (!class_exists('\WordPressPopularPosts\Helper')) {
            return;
        }

        $arguments = [
            'public' => true,
            'show_ui' => true,
            'show_in_nav_menus' => true,
        ];

        foreach (get_post_types($arguments, 'objects') as $name => $type) {

            if (!$type->rest_base || $name === $type->rest_base) {
                continue;
            }

            $baseQuery = Str::camelCase([$type->rest_base, 'Query'], true);
            $source->addType($baseQuery, Type\PopularPostsQueryType::class, $type);
        }
    }
}
