<?php

namespace YOOtheme\Builder\Wordpress\Toolset\Type;

use YOOtheme\Builder\Source;
use YOOtheme\Builder\Wordpress\Toolset\Helper;
use YOOtheme\Str;

class RelationshipType
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var array
     */
    protected $relationship;

    public function __construct($name, $relationship)
    {
        $this->name = $name;
        $this->relationship = $relationship;
    }

    public function __invoke(Source $source)
    {
        $name = Str::camelCase($this->name, true);

        $fields = [
            'post' => [
                'type' => $name,
                'metadata' => [
                    'label' => 'Post',
                ],
            ],

        ];

        $resolvers = [
            'post' => function ($item) {
                return get_post($item['post']);
            },
        ];

        if (isset($this->relationship['roles']['intermediary'])) {
            $groups = Helper::groups('post', $this->relationship['roles']['intermediary']['types']);

            if (isset($groups[0])) {
                $customFields = Helper::fields('post', $groups[0]->get_field_slugs());

                foreach ($customFields as $field) {
                    $config = [
                        'type' => 'String',
                        'metadata' => [
                            'label' => $field['name'],
                            'group' => $groups[0]->get_display_name(),
                        ],
                    ];

                    $fieldConfig = Helper::loadField($field, $config);
                    if (!$fieldConfig) {
                        continue;
                    }

                    $fields[$field['slug']] = $fieldConfig;
                    $resolvers[$field['slug']] = function ($item) use ($field) {
                        if (isset($item['intermediary'])) {
                            return $this->resolveIntermediaryField($field, get_post($item['intermediary']));
                        }
                    };
                }
            }
        }

        return compact('fields', 'resolvers');
    }

    protected function resolveIntermediaryField($field, $item)
    {
        $fieldService = new \Types_Field_Service(false);
        $fieldInstance = $fieldService->get_field(new \Types_Field_Gateway_Wordpress_Post(), $field['id'], $item->ID);

        if ($fieldInstance) {
            return Helper::getFieldValue($fieldInstance, $field);
        }
    }
}
