<?php

return [

    '2.1.0-beta.0.1' => function ($node, array $params) {

        if (@$node->props['maxwidth'] === 'xxlarge') {
            $node->props['maxwidth'] = '2xlarge';
        }

        /**
         * @var $type
         */
        extract($params);

        // move declaration of uk-hidden class to visibility settings
        if ($type->element && empty($node->props['visibility']) && !empty($node->props['class'])) {
            $node->props['class'] = trim(preg_replace_callback('/(^|\s+)uk-hidden@(s|m|l|xl)/', function ($match) use ($node) {
                $node->props['visibility'] = 'hidden-' . $match[2];
                return '';
            }, $node->props['class']));
        }

    },

];
